
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Online earning site" name="author">
    <meta name="keywords" content="">

    <title><?php echo e(website_title()); ?></title>
    <link rel="icon" href="<?php echo e(URL::to(website_favicon())); ?>" type="image/x-icon" />
    <?php echo $__env->make('user.layouts.partials.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('css'); ?>

    
    <link href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.0.0-
    alpha/css/bootstrap.css" rel="stylesheet">

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

    <link rel="stylesheet" type="text/css"
        href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
     
    <style>
        .mh-200{
            min-height: 200px
        }
        
        .mh-300{
            min-height: 300px
        }
        .body-top-section {
            background-color: #4285f4;
        }
    </style>
   
    <?php $__currentLoopData = head_scripts(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head_script): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($head_script->script): ?>
            <?php echo $head_script->script; ?>

        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</head>


<body data-sidebar="dark">

    <div id="layout-wrapper">
        <?php echo $__env->make('user.layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('user.layouts.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="main-content">
            <div class="page-content" style="background-color: #F8F9FE">

                <div class="body-top-section">
                    <div class="mb-2 d-flex justify-content-center gap-2">
                        <button class="btn btn-sm text-white mbl-btn mbl-mt" type="button" style="background-color: #000066; width: 140px;">
                            Earning: $<?php echo e(number_format(Auth::user()->earning_balance, 3)); ?>

                        </button>
                    
                        <button class="btn btn-sm text-white mbl-btn mbl-mt mr-3" type="button" style="background-color: #008000; width: 142px; height: 30px;">
                            Deposit: $<?php echo e(number_format(Auth::user()->deposit_balance, 3)); ?>

                        </button>
                    </div>
                    
                    <?php echo $__env->make('user.layouts.partials.headline-and-ads', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
    
                <?php if(google_head_ad()): ?>
                    <div class="container-fluid mh-200">
                        <div class="row justify-content-center">
                            <div class="col-12">
                                <?php echo google_head_ad()->code; ?>

                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="container-fluid">
                    <?php echo $__env->yieldContent('user-content'); ?>
                </div>
                <?php echo $__env->make('user.layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>

        <?php echo $__env->make('user.layouts.partials.notification-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <?php echo $__env->make('user.layouts.partials.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('js'); ?>


    
    <script>
        <?php if(Session::has('message')): ?>
            toastr.options =
            {
                "closeButton" : true,
                "progressBar" : true
            }
            toastr.success("<?php echo e(session('message')); ?>");
        <?php endif; ?>

        <?php if(Session::has('error')): ?>
            toastr.options =
            {
                "closeButton" : true,
                "progressBar" : true
            }
            toastr.error("<?php echo e(session('error')); ?>");
        <?php endif; ?>

        <?php if(Session::has('info')): ?>
            toastr.options =
            {
                "closeButton" : true,
                "progressBar" : true
        }
            toastr.info("<?php echo e(session('info')); ?>");
        <?php endif; ?>

        <?php if(Session::has('warning')): ?>
            toastr.options =
            {
                "closeButton" : true,
                "progressBar" : true
            }
            toastr.warning("<?php echo e(session('warning')); ?>");
        <?php endif; ?>
    </script>

    <script>
        <?php if(count($errors) > 0): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                toastr.error("<?php echo e($error); ?>");
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        
        function showNotificationModal(){
            $('#notification_modal').modal('show');
        }
        
        function closeNotificationModal(){
            $('#notification_modal').modal('hide');
        }
    
       $(document).mouseup(function(e) {
            var sidebar = $("#vertical_menu");
    
            if (!sidebar.is(e.target) && sidebar.has(e.target).length === 0) {
                $("body").removeClass("sidebar-enable");
            }
        });
    </script>
</body>
</html>
<?php /**PATH /home/sakibwe1/microjobtwo.sakibwebtech.website/resources/views/user/layouts/master.blade.php ENDPATH**/ ?>